<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ComponentPlaylist extends Model 
{

    protected $table = 'component_playlist';
    public $timestamps = true;
    protected $fillable = array('node_id', 'name', 'has_audio', 'has_video', 'has_stream');

    public function node()
    {
        return $this->belongsTo('App\Models\Node');
    }

    public function campaignScheduledItems()
    {
        return $this->hasMany('App\Models\CampaignScheduledItem');
    }

    public function componentPlaylistItems()
    {
        return $this->hasMany('App\Models\ComponentPlaylistItem');
    }

    public function componentProgramItems()
    {
        return $this->hasMany('App\Models\ComponentProgramItem');
    }

    public function streamScheduledItems()
    {
        return $this->hasMany('App\Models\StreamScheduledItem');
    }

}